#include <Wire.h>
#include <LiquidCrystal.h>
#define I2C_RTC 0x68 // 7 bit address (without last bit - look at the datasheet)
#define rxPin 0
#define txPin 1

// LiquidCrystal(rs, enable, d0, d1, d2, d3, d4, d5, d6, d7);
LiquidCrystal lcd(10, 11, 4, 5, 6, 7);

// RTC definitions
byte second;
byte minute;
byte hour;
byte weekday;
byte day;
byte month;
byte year;
char* weekdayname[] = {"Sun", "Mon", "Tus", "Wed", "Thu", "Fri", "Sat"};
// Serial definitions
unsigned int address = 0;


// the setup routine runs once when you press reset:
void setup() 
{  
    Wire.begin();
    second = 00; // Second (0-59)
    minute = 59; // Minute (0-59)
    hour = 12;   // Hour (1-12)
    weekday = 4; // Day of the week (1-7)
    day = 01;    // Day (1-31)
    month = 01;  // Month (1-12)
    year = 20;   // Year (0-99)
    Wire.beginTransmission(I2C_RTC);  // Select RTC
    Wire.write(0);                    // Start address
    Wire.write(DecToBcd(second));     // Second
    Wire.write(DecToBcd(minute));     // Minute
    Wire.write(DecToBcd(hour) | 0b01100000); // Hour
    Wire.write(DecToBcd(weekday));    // Weekday
    Wire.write(DecToBcd(day));        // Day
    Wire.write(DecToBcd(month));      // Month (with century bit = 0)
    Wire.write(DecToBcd(year));       // Year
    Wire.endTransmission();    
    delay(100);  
    lcd.begin(20, 4);   
    lcd.setCursor(0, 0); lcd.print("====================");  
    lcd.setCursor(0, 1); lcd.print("Time    :  :        ");
    lcd.setCursor(0, 2); lcd.print("Date    /  /20      ");      
    lcd.setCursor(0, 3); lcd.print("===================="); delay(500);   
    Serial.begin(9600);
    Serial.println("FARESPCB Co.");
    Serial.println("Arduino Uno Development Kit.");
}

// the loop routine runs over and over again forever:
void loop()
{


    Wire.beginTransmission(I2C_RTC);
    Wire.write(0); // Start address
    Wire.endTransmission();
    Wire.requestFrom(I2C_RTC, 7);
    if (7 <= Wire.available())
    {
      second = Wire.read();
      minute = Wire.read();
      hour = Wire.read();
      weekday = Wire.read();
      day = Wire.read();
      month = Wire.read();
      year = Wire.read();
      Lcd_Display(6,1,hour & 0b00011111);
      Lcd_Display(9,1,minute);
      Lcd_Display(12,1,second);
      lcd.setCursor(17, 1);
      if ( (hour & 0b00100000) == 0 )
      {
          lcd.print("AM");
      }
      else
      {
          lcd.print("PM");
      }
      Lcd_Display(6,2,day);
      Lcd_Display(9,2,month);
      Lcd_Display(14,2,year);
      lcd.setCursor(17, 2); lcd.print(weekdayname[weekday - 1]);
    }
  delay(1000);
}

//============================================================
void Lcd_Display(byte Col,byte Row,byte Data)
{
    lcd.setCursor(Col, Row);
    lcd.print((Data & 0b11110000) >> 4);
    lcd.setCursor(Col + 1, Row);
    lcd.print(Data & 0b00001111);
}
  
// Converts a decimal to BCD (binary coded decimal)
byte DecToBcd(byte value)
{
    return (value / 10 * 16 + value % 10);
}
